<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations. new
     */ 
    public function up(): void
    {
        Schema::create('referral_conditions', function (Blueprint $table) {
            $table->increments('id');
            $table->string('referral_type');
            $table->text('label_referral')->nullable();
            $table->longText('description')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('referral_conditions');
    }
};
