<?php

namespace App\Helpers\Rides;

use Kreait\Firebase\Contract\Database;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use App\Models\Payment\PaymentRequest;
use App\Models\User;
use App\Base\Constants\Auth\Role;
use App\Models\Request\Request as RequestModel;
use App\Models\Admin\Subscription;
use App\Models\Payment\UserWallet;
use App\Models\Payment\OwnerWallet;
use App\Models\Payment\DriverWallet;
use App\Models\Admin\SubscriptionDetail;
use App\Models\Payment\UserWalletHistory;
use App\Models\Payment\OwnerWalletHistory;
use App\Models\Payment\DriverWalletHistory;
use App\Base\Constants\Masters\WalletRemarks;
use App\Jobs\Notifications\SendPushNotification;


trait StorePaymentDetailForRideHelper
{

    protected function validatePay($request)
    {

        $payment = $this->validatePayment($request);

        if(!$payment){

            $payment_params = $request;

            $payment_id = str_random(16);
            $payment_params['id'] = $payment_id;
            $payment_params['status'] = 'P';

            $user = User::find($request['user_id']);

            if(!$user){
                return $this->throwCustomException('User not found');
            }
            $currency = $user->countryDetail->currency_code ?? "PHP";
            $payment_params['currency'] = $currency;

            PaymentRequest::create($payment_params);

            $payment = PaymentRequest::where('id',$payment_id)->first();
        }

        return $payment;
    }


    protected function validatePayment($request)
    {
        $conditional_time = now()->subMinutes(30)->toDateTimeString();

        if(!isset($request['user_id']) || !$request['user_id']){
                return $this->throwCustomException('User not found');
        }

        $query = PaymentRequest::where('user_id',$request['user_id'])
                    ->where('created_at',">",$conditional_time)
                    ->where('status','P')
                    ->where('amount',$request['amount']);

        $payment_for = 'wallet';

        if(isset($request['plan_id']) && $request['plan_id']){
            $query = $query->where('plan_id',$request['plan_id']);
            $payment_for = 'subscription';
        }
        if(isset($request['request_id']) && $request['request_id']){
            $query = $query->where('request_id',$request['request_id']);
            $payment_for = null;
        }
        if($payment_for){
            $query = $query->where('payment_for',$request['payment_for']);
        }
        // dd($query->toSql(),$request['request_id']);

        return $query->first();
    }

    protected function getPayment($payment_id)
    {
        $payment = PaymentRequest::where('id',$payment_id)->first();
        return $payment;
    }

    protected function makePayment($payment_id,$database)
    {
        PaymentRequest::where('id',$payment_id)->update(['is_paid'=>true,'status'=>'S']);
        $payment = $this->getPayment($payment_id);

        $amount = ($payment->amount);
        $payment_for = $payment->payment_for;
        $user_id = $payment->user_id;
        $request_id = $payment->request_id;
        $plan_id = $payment->plan_id;

//Handle the sucess payment  Here
           if ($payment_for=="wallet") {

                $request_id = null;

                $user = User::find($user_id);

                if ($user->hasRole('user')) {
                    $wallet_model = new UserWallet();
                    $wallet_add_history_model = new UserWalletHistory();
                    $user_id = $user->id;
                } elseif($user->hasRole('driver')) {
                            $wallet_model = new DriverWallet();
                            $wallet_add_history_model = new DriverWalletHistory();
                            $user_id = $user->driver->id;
                }else {
                            $wallet_model = new OwnerWallet();
                            $wallet_add_history_model = new OwnerWalletHistory();
                            $user_id = $user->owner->id;
                }

                $user_wallet = $wallet_model::firstOrCreate([
                    'user_id'=>$user_id]);
                $user_wallet->amount_added += $amount;
                $user_wallet->amount_balance += $amount;
                $user_wallet->save();
                $user_wallet->fresh();

                $wallet_add_history_model::create([
                    'user_id'=>$user_id,
                    'amount'=>$amount,
                    'transaction_id'=>$payment_id,
                    'remarks'=>WalletRemarks::MONEY_DEPOSITED_TO_E_WALLET,
                    'is_credit'=>true]);


                // $title = custom_trans('amount_credited_to_your_wallet_title');
                // $body = custom_trans('amount_credited_to_your_wallet_body');

                // dispatch(new SendPushNotification($user,$title,$body));

                $notification = \DB::table('notification_channels')
                        ->where('topics', 'User Wallet Amount') // Match the correct topic
                        ->first();

            //    send push notification 
                if ($notification && $notification->push_notification == 1) {
                        // Determine the user's language or default to 'en'
                    $userLang = $user->lang ?? 'en';
                    // dd($userLang);
    
                    // Fetch the translation based on user language or fall back to 'en'
                    $translation = \DB::table('notification_channels_translations')
                        ->where('notification_channel_id', $notification->id)
                        ->where('locale', $userLang)
                        ->first();
    
                    // If no translation exists, fetch the default language (English)
                    if (!$translation) {
                        $translation = \DB::table('notification_channels_translations')
                            ->where('notification_channel_id', $notification->id)
                            ->where('locale', 'en')
                            ->first();
                    }            
                    
                    $title =  $translation->push_title ?? $notification->push_title;
                    $body = strip_tags($translation->push_body ?? $notification->push_body);
                    dispatch(new SendPushNotification($user, $title, $body));
                }



            } elseif ($payment_for == 'subscription') {
                $plan = Subscription::find($plan_id);

                $user = User::find($user_id);
                $driver_wallet = $user->driver->DriverWallet;
                $driver_wallet->amount_spent += $amount;
                $driver_wallet->save();

                $user->driver->driverWalletHistory()->create([
                    'amount'=>$amount,
                    'transaction_id'=>$payment_id,
                    'remarks'=>WalletRemarks::SUBSCRIPTION_FEE,
                    'is_credit'=>false,
                ]);

                $driver = $user->driver;

                $expire_at = Carbon::parse(now())->addDay($plan->subscription_duration)->toDateTimeString();
                 $params = [
                    'driver_id' => $driver->id,
                    'subscription_id' => $plan_id,
                    'amount' => $amount,
                    'payment_opt' => 0,
                    'expired_at' => $expire_at,
                ];
                $params['transaction_id'] = $payment_id;
                $params['subscription_type'] = 1;
                $subscription = SubscriptionDetail::create($params);
                $driver->update([
                    'is_subscribed' => true,
                    'subscription_detail_id' => $subscription->id,
                ]);

                // $title = custom_trans('subscription_title', [], $user->lang);
                // $body = custom_trans('subscription_body', [], $user->lang);
                

                // dispatch(new SendPushNotification($user,$title,$body));

                $notification = \DB::table('notification_channels')
                            ->where('topics', 'Driver Subscription') // Match the correct topic
                            ->first();

            //    send push notification 
                if ($notification && $notification->push_notification == 1) {
                        // Determine the user's language or default to 'en'
                    $userLang = $user->lang ?? 'en';
                    // dd($userLang);
    
                    // Fetch the translation based on user language or fall back to 'en'
                    $translation = \DB::table('notification_channels_translations')
                        ->where('notification_channel_id', $notification->id)
                        ->where('locale', $userLang)
                        ->first();
    
                    // If no translation exists, fetch the default language (English)
                    if (!$translation) {
                        $translation = \DB::table('notification_channels_translations')
                            ->where('notification_channel_id', $notification->id)
                            ->where('locale', 'en')
                            ->first();
                    }            
                    
                    $title =  $translation->push_title ?? $notification->push_title;
                    $body = strip_tags($translation->push_body ?? $notification->push_body);
                    dispatch(new SendPushNotification($user, $title, $body));
                }
            }else{


                $request_detail = RequestModel::where('id', $request_id)->first();

                
                $web_booking_value = $request_detail->web_booking ?? 0;

              
                $request_detail->update(['is_paid' => true]);


                $driver_commision = $request_detail->requestBill->driver_commision;
                if($request_detail->driverDetail->owner()->exists())
                {
                    $wallet_model = new OwnerWallet();
                    $wallet_add_history_model = new OwnerWalletHistory();
                    $user_id = $request_detail->driverDetail->owner_id;
                }else{
                    $wallet_model = new DriverWallet();
                    $wallet_add_history_model = new DriverWalletHistory();
                    $user_id = $request_detail->driver_id;
                }
                /*wallet Modal*/
                $user_wallet = $wallet_model::firstOrCreate([
                'user_id'=>$user_id]);
                $user_wallet->amount_added += $driver_commision;
                $user_wallet->amount_balance += $driver_commision;
                $user_wallet->save();
                $user_wallet->fresh();
                /*wallet history*/
                $wallet_add_history_model::create([
                'user_id'=>$user_id,
                'amount'=>$driver_commision,
                'transaction_id'=>$payment_id,
                'remarks'=>WalletRemarks::TRIP_COMMISSION_FOR_DRIVER,
                'is_credit'=>true]);

                $additional_charges_amount = $request_detail->requestBill->additional_charges_amount;

                if($additional_charges_amount > 0){


                    if($request_detail->driverDetail->owner()->exists())
                    {
                        $owner_wallet = $request_detail->driverDetail->owner->ownerWalletDetail;
                        $owner_wallet->amount_added += $additional_charges_amount;
                        $owner_wallet->amount_balance += $additional_charges_amount;
                        $owner_wallet->save();
            
                        $owner_wallet_history = $request_detail->driverDetail->owner->ownerWalletHistoryDetail()->create([
                            'amount'=>$additional_charges_amount,
                            'transaction_id'=>$payment_id,
                            'remarks'=>WalletRemarks::ADDITIONAL_CHARGE_AMOUNT,
                            'is_credit'=>true
                        ]);
                    }else{
                        $driver_wallet = $request_detail->driverDetail->driverWallet;
                        $driver_wallet->amount_added += $additional_charges_amount;
                        $driver_wallet->amount_balance += $additional_charges_amount;
                        $driver_wallet->save();
            
                        $driver_wallet_history = $request_detail->driverDetail->driverWalletHistory()->create([
                            'amount'=>$additional_charges_amount,
                            'transaction_id'=>$payment_id,
                            'remarks'=>WalletRemarks::ADDITIONAL_CHARGE_AMOUNT,
                            'is_credit'=>true
                        ]);
                    }
                }

                $notification = \DB::table('notification_channels')
                    ->where('topics', 'User Wallet Amount') // Match the correct topic
                    ->first();

            //    send push notification 
                if ($notification && $notification->push_notification == 1) {
                        // Determine the user's language or default to 'en'
                    $userLang = $request_detail->driverDetail->user->lang ?? 'en';
                    // dd($userLang);
    
                    // Fetch the translation based on user language or fall back to 'en'
                    $translation = \DB::table('notification_channels_translations')
                        ->where('notification_channel_id', $notification->id)
                        ->where('locale', $userLang)
                        ->first();
    
                    // If no translation exists, fetch the default language (English)
                    if (!$translation) {
                        $translation = \DB::table('notification_channels_translations')
                            ->where('notification_channel_id', $notification->id)
                            ->where('locale', 'en')
                            ->first();
                    }            
                    
                    $title =  $translation->push_title ?? $notification->push_title;
                    $body = strip_tags($translation->push_body ?? $notification->push_body);
                    dispatch(new SendPushNotification($request_detail->driverDetail->user, $title, $body));
                }


// 
                if ($request_detail->promo_id){
                    $discount = $request_detail->requestBill->promo_discount;
                    if($discount>0) {
                        if($request_detail->driverDetail->owner()->exists())
                        {
                            $owner_wallet = $request_detail->driverDetail->owner->ownerWalletDetail;
                            $owner_wallet->amount_added += $discount;
                            $owner_wallet->amount_balance += $discount;
                            $owner_wallet->save();
                
                            $owner_wallet_history = $request_detail->driverDetail->owner->ownerWalletHistoryDetail()->create([
                                'amount'=>$discount,
                                'transaction_id'=>$payment_id,
                                'remarks'=>WalletRemarks::DISCOUNTED_AMOUNT,
                                'is_credit'=>true
                            ]);
                        }else{
                            $driver_wallet = $request_detail->driverDetail->driverWallet;
                            $driver_wallet->amount_added += $discount;
                            $driver_wallet->amount_balance += $discount;
                            $driver_wallet->save();
                
                            $driver_wallet_history = $request_detail->driverDetail->driverWalletHistory()->create([
                                'amount'=>$discount,
                                'transaction_id'=>$payment_id,
                                'remarks'=>WalletRemarks::DISCOUNTED_AMOUNT,
                                'is_credit'=>true
                            ]);
                        }
                    }
                }     

                $database->getReference('requests/'.$request_detail->id)->update(['is_paid'=>1]);

            }

        return $payment;
    }
    
}
